<?php

namespace Incevio\Package\Wallet\Console\Commands;

use Illuminate\Console\Command;
use Incevio\Package\Wallet\Models\Transaction;

class TransactionPending extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'wallet:release-payment';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check the holding dates of payments and release the pending balance.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $duration = get_order_amount_pending_duration();
        $transactions = Transaction::all();
        foreach ($transactions as $transaction) {
            if (isset($transaction->meta['order_id'])) {
                $days = now()->subDays($duration);

                if ($transaction->created_at->lessThan($days)) {
                    $transaction->confirmed = 1;
                    $transaction->save();

                    //add balance to wallet
                    $wallet = $transaction->wallet;
                    $balance = ($wallet->balance + $transaction->amount);
                    $wallet->balance = $balance;
                    $wallet->save();
                }
            }
        }
    }
}
